#!/usr/bin/perl 
#####################################################
#
# SnS-Align.pl (Version 1.0) is protein alignment program using both structure and sequence
# Copyright (C) 2005 Ganiraju C.Manyam
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#
#####################################################
#
use strict;
use Tk;
use Tk::FileSelect;
use Tk::ROText;
use Tk::Button;
use Tk::BrowseEntry;
use Tk::Dialog;
use Tk::ProgressBar;
use File::Basename;
use Cwd;
#
my ($textpad1,$textpad2,$submit,$P_label,$GP_label,$GP_value,$GE_label,$GE_value,$m_list,$matrix_selected);
my ($file1,$file2,$file3,$tfile,$path,$mb,$geox,$geoy,@hits);
my $mw;my ($mw2,$canvas1,$canvas2);my ($alignagain,$savealign,$viewsummary,$exit);
my ($GP,$GE,$null_label1,$null_label2,$null_label3);
my (@identities,@iden_pos,@bonus_score,$seq_selected,$s_list);
my $th;
#
# The routine checkFasta is used to check whether
# a file is in a FASTA file or not
#
# It will also validate the protein Sequence
sub checkFasta
{
	my ($line,$fflag,$tfile,$aflag);
	$fflag=0;$tfile=$_[0];$aflag=1;
	open CHKIN,$_[0];
	$line=<CHKIN>;
	if($line !~ m/^(>)/)
	{
		$mb = $canvas1 -> messageBox(-message=>"File $tfile is not FASTA formatted",
               -type=>'ok',-title=>"SnS-Align");
				if($mb)
				{
					close CHKIN;
					if($tfile eq $file1)
					{
						$file1="";
						$textpad1->delete('1.0', 'end');
					}
					elsif($tfile eq $file2)
					{
						$file2="";
						$textpad2->delete('1.0', 'end');
					}
				}
				return -1;
	}
	close CHKIN;
	open CHKIN,$tfile;
	while($line=<CHKIN>)
	{
		chomp $line;
		if($line=~m/^(\s*)$/)
		{
			next;
		}
		elsif(($aflag==1) && ($line=~m/^(>)/))
		{
			$aflag=0;
			$fflag=1;
			next;
		}
		elsif(($aflag==0) && ($line=~m/^(>)/))
		{
			close CHKIN;
				if($seq_selected eq "Protein")
				{
				$mb = $canvas1 -> messageBox(-message=>"In File $tfile, Protein sequence is missing or is not FASTA formatted",
		                -type=>'ok',-title=>"SnS-Align");
				}
				else
				{
				$mb = $canvas1 -> messageBox(-message=>"In File $tfile, DNA sequence is missing or is not FASTA formatted",
		                -type=>'ok',-title=>"SnS-Align");
				}
				if($mb)
				{
					if($tfile eq $file1)
					{
						$file1="";
						$textpad1->delete('1.0', 'end');
					}
					elsif($tfile eq $file2)
					{
						$file2="";
						$textpad2->delete('1.0', 'end');
					}
				}
				return -1;
		}
		elsif($fflag==0)
		{
				close CHKIN;
				$mb = $canvas1 -> messageBox(-message=>"File $tfile is not FASTA formatted",
		                -type=>'ok',-title=>"SnS-Align");
				if($mb)
				{
					if($tfile eq $file1)
					{
						$file1="";
						$textpad1->delete('1.0', 'end');
					}
					elsif($tfile eq $file2)
					{
						$file2="";
						$textpad2->delete('1.0', 'end');
					}
				}
				return -1;
		}
		if($fflag==1)
		{
			if($line=~m/^((\s*[A-Z]+\s*)+)$/i)
			{
				if((($seq_selected eq "Protein") && ($line=~m/(B|J|O|U|X|Z)/i))||(($seq_selected eq "DNA") && ($line=~m/[BDEFHIJKLMNOPQRSUVWXYZ]/i)))
				{
					close CHKIN;
					if($seq_selected eq "Protein")
					{
					$mb = $mw -> messageBox(-message=>"Unknown amino acid \"$&\" in File $tfile",
		            					-type=>'ok',-title=>"SnS-Align");
					}
					else
					{
					$mb = $mw -> messageBox(-message=>"Unknown Nucleotide \"$&\" in File $tfile",
		            					-type=>'ok',-title=>"SnS-Align");
					}
				if($mb)
				{
					if($tfile eq $file1)
					{
						$file1="";
						$textpad1->delete('1.0', 'end');
					}
					elsif($tfile eq $file2)
					{
						$file2="";
						$textpad2->delete('1.0', 'end');
					}
				}
						return -1;
				}
				else
				{
					$aflag=1;
				}
			}
			else
			{
				close CHKIN;
				if($seq_selected eq "Protein")
				{
				$mb = $mw -> messageBox(-message=>"Unknown protein sequence in File $tfile",
		            					-type=>'ok',-title=>"SnS-Align");
				}
				else
				{
				$mb = $mw -> messageBox(-message=>"Unknown DNA sequence in File $tfile",
		            					-type=>'ok',-title=>"SnS-Align");
				}
				if($mb)
				{
					if($tfile eq $file1)
					{
						$file1="";
						$textpad1->delete('1.0', 'end');
					}
					elsif($tfile eq $file2)
					{
						$file2="";
						$textpad2->delete('1.0', 'end');
					}
				}
						return -1;
			}
		}
	}
	close CHKIN;
}
#
# The routine parse_garnier is used to parse the
# secondary structure obtained from the garnier
# program of EMBOSS package
#
sub parse_garnier
{
	open GAIN,$_[0];
	open GOUT,">$_[1]";
	my ($line,$seq_name,@seqarray,@aarray,$i,$seq);
	while($line=<GAIN>)
	{
		chomp $line;
		if($line =~ m/^(\# Sequence: )(\S+)(\s+)(from)/)
		{
			$seq_name=$2;
			print GOUT ">$seq_name\n";
		}
		if($line =~ m/^(\s{6}(\w+))/)
		{
			$line=$2;
			@seqarray=split("",$line);
			next;
		}
		if($line =~ m/^(helix)/)
		{
			$line =substr($line,6);
			@aarray=split("",$line);
			for($i=0;$i<@aarray;$i++) {
				if($aarray[$i] eq "H")
				{
					$seqarray[$i] = "B";
				}
			}
			next;
		}
		if($line =~ m/^(sheet)/)
		{
			$line =substr($line,6);
			@aarray=split("",$line);
			for($i=0;$i<@aarray;$i++) {
				if($aarray[$i] eq "E")
				{
					$seqarray[$i] = "Z";
				}
			}
			$seq=join('',@seqarray);
			print GOUT $seq."\n";
			next;
		}
	}
	close GAIN;
	close GOUT;
}
#
# The routine is used to find the reverse complement
# of a given sequence
#
sub complement
{
	my $patt=$_[0];
	my (@chars,$j);
	@chars=split("",$patt);
	for($j=0; $j < scalar(@chars); $j++)
	{
		if($chars[$j] eq "A")
		{
			$chars[$j] = "T";
		}
		elsif($chars[$j] eq "G")
		{
			$chars[$j] = "C";
		}
		elsif($chars[$j] eq "T")
		{
			$chars[$j] = "A";
		}
		elsif($chars[$j] eq "C")
		{
			$chars[$j] = "G";
		}
	}
	$patt=join("",@chars);
	$patt=reverse($patt);
	return $patt;
}
#
# This function is used to translate a given DNA
# sequence to a protein sequence
#
sub translation
{
	my ($seq,$codon,%AA,$tran_seq,$i);
	$seq=$_[0];
	%AA = (
		"TTT" => "F",
"TTC" => "F",
"TTA" => "L",
"TTG" => "L",
"TCT" => "S",
"TCC" => "S",
"TCA" => "S",
"TCG" => "S",
"TAT" => "Y",
"TAC" => "Y",
"TGT" => "C",
"TGC" => "C",
"TGG" => "W",
"CTT" => "L",
"CTC" => "L",
"CTA" => "L",
"CTG" => "L",
"CCT" => "P",
"CCC" => "P",
"CCA" => "P",
"CCG" => "P",
"CAT" => "H",
"CAC" => "H",
"CAA" => "Q",
"CAG" => "Q",
"CGT" => "R",
"CGC" => "R",
"CGA" => "R",
"CGG" => "R",
"ATT" => "I",
"ATC" => "I",
"ATA" => "I",
"ATG" => "M",
"ACT" => "T",
"ACC" => "T",
"ACA" => "T",
"ACG" => "T",
"AAT" => "N",
"AAC" => "N",
"AAA" => "K",
"AAG" => "K",
"AGT" => "S",
"AGC" => "S",
"AGA" => "R",
"AGG" => "R",
"GTT" => "V",
"GTC" => "V",
"GTA" => "V",
"GTG" => "V",
"GCT" => "A",
"GCC" => "A",
"GCA" => "A",
"GCG" => "A",
"GAT" => "D",
"GAC" => "D",
"GAA" => "E",
"GAG" => "E",
"GGT" => "G",
"GGC" => "G",
"GGA" => "G",
"GGG" => "G"
	);
	for($i=0;$i<length($seq);$i=$i+3)
	{
		$codon=substr($seq,$i,3);
		$codon=uc($codon);
		if(($codon eq "TAA")||($codon eq "TAG")||($codon eq "TGA"))
		{
			last;
		}
		$tran_seq=$tran_seq.$AA{$codon};
	}
	return $tran_seq;
}
#
# The routine is used to find all the orfs 
# of a given DNA sequence
#
sub findallorf
{
	my ($line,$seq,$head,$i);
	open IN,$_[0];
	open OUT,">temp/translated_DB.fas";
	while ($line =<IN>)
	{
		if($line=~m/^>/)
		{
			$head=$line;
			last;
		}
	}
	while ($line =<IN>)
	{
		if($line =~ m/^>/)
		{
			$head=substr($head,1);
			for($i=0;$i<3;$i++)
			{
				print OUT ">t".($i+1)."_".$head;
				print OUT translation(substr($seq,$i))."\n";
			}
			$seq=complement($seq);
			for($i=0;$i<3;$i++)
			{
				print OUT ">t".($i+4)."_".$head;
				print OUT translation(substr($seq,$i))."\n";
			}
			$seq="";
			$head=$line;
		}
		chomp $line;
		$line =~ s/\s+//g;
		$seq=$seq.$line;
	}
	$head=substr($head,1);
	for($i=0;$i<3;$i++)
	{
		print OUT ">t".($i+1)."_".$head;
		print OUT translation(substr($seq,$i))."\n";
	}
	$seq=complement($seq);
	for($i=0;$i<3;$i++)
	{
		print OUT ">t".($i+4)."_".$head;
		print OUT translation(substr($seq,$i))."\n";
	}
	close IN;
	close OUT;
}
#
# The routine is used to identify 
# longest ORF
#
sub find_lorf
{
	my ($line,$seq,$head,$maxlen,$maxpos,@prot_seq,$i);
	open IN,$_[0];
	open OUT,">temp/translated_Query.fas";
	while ($line =<IN>)
	{
		if($line=~m/^>/)
		{
			$head=$line;
			last;
		}
	}
	while ($line =<IN>)
	{
		if($line=~m/^>/)
		{
			for($i=0;$i<3;$i++)
			{
				$prot_seq[@prot_seq]=translation(substr($seq,$i));
			}
			$seq=complement($seq);
			for($i=0;$i<3;$i++)
			{
				$prot_seq[@prot_seq]=translation(substr($seq,$i));
			}
			$seq="";
			$head=$line;
		}
		chomp $line;
		$line =~ s/\s+//g;
		$seq=$seq.$line;
	}
	for($i=0;$i<3;$i++)
	{
		$prot_seq[@prot_seq]=translation(substr($seq,$i));
	}
	$seq=complement($seq);
	for($i=0;$i<3;$i++)
	{
		$prot_seq[@prot_seq]=translation(substr($seq,$i));
	}
	$maxlen=0;$maxpos=0;
	for($i=0;$i<scalar(@prot_seq);$i++)
	{
		if($maxlen < length($prot_seq[$i]))
		{
			$maxlen=length($prot_seq[$i]);
			$maxpos=$i;
		}
	}
	$head=substr($head,1);
	print OUT ">t_".$head;
	print OUT $prot_seq[$maxpos]."\n";
	close IN;
	close OUT;
}
#
# The routine SS_align calls the garnier and
# water programs EMBOSS package
#
# It will also validate the inputs to GUI
#
sub ss_align {
my ($process,$tfile2);
if(!($file1 && $file2))
{
	$mw -> messageBox(-message=>"Query or DB not found",
	            					-type=>'ok',-title=>"SnS-Align");
	return;
}
if(checkFasta($file1)== -1)
	{
		return;
	}
if(checkFasta($file2)== -1)
	{
		return;
	}
if($seq_selected ne "Protein")
	{
		find_lorf($file1);
		findallorf($file2);
		$file1="temp/translated_Query.fas";
		$file2="temp/translated_DB.fas";
	}
if(($GE !~ m/^(\d+|(\d+\.\d+))$/) || ($GP !~ m/^(\d+|(\d+\.\d+))$/))
	{
		$mw -> messageBox(-message=>"Gap Penalty should be an integer or floating point number",
	            					-type=>'ok',-title=>"SnS-Align");
		return;
	}

	$canvas1->delete( $submit );
	$submit->destroy();
	$process=$canvas1->Label(-text => 'Processing, Please Wait..',
							 -font =>"LucidaConsole 12 bold",
							);
	$process -> grid(-row=>10,-column=>3,-columnspan=>3);
	$canvas1->grid();
	$canvas1->update;

$file3=$path."temp/ssalign";
$tfile=$path."temp/garnier_temp00.out";
system("garnier -sequence \"$file1\" -outfile \"$tfile\"");
print "for Query\n\n";
parse_garnier($tfile,$path."temp/parse_garnier001.out");
system("garnier -sequence \"$file2\" -outfile \"$tfile\"");
print "for DB\n\n";
parse_garnier($tfile,$path."temp/parse_garnier002.out");
$matrix_selected=$path."data/".$matrix_selected.".ss";
$tfile=$path."temp/parse_garnier001.out";
$tfile2=$path."temp/parse_garnier002.out";
open CLEANOUT,">$file3";
close CLEANOUT;
system("water \"$tfile\" \"$tfile2\" -outfile \"$file3\" -gapopen $GP -gapextend $GE -datafile \"$matrix_selected\"");

bonus_Score();
sort_file($file3,$tfile);
$file3=$tfile;
recreate_canvas1();
}
#
# The routine load_file1 is used to take the 
# query protein in
#
sub load_file1 {
   $file1= $canvas1->getOpenFile();
   #$textpad1->text="";
   $textpad1->delete('1.0', 'end');
   if($file1) {
   $textpad1->insert(
						'insert',sprintf($file1)
					);
   }
}
#
# The routine load_file2 is used to take the 
# database (of proteins) in
#
sub load_file2 {
   $file2= $canvas1->getOpenFile();
   $textpad2->delete('1.0', 'end');
   if($file2) {
   $textpad2->insert(
						'insert',sprintf($file2)
					);
   }
}
#
# The routine calculates the bonus score for the alignments,
# i.e. score for residues which are conserved in sequence and 
# structure also
#
sub bonus_Score
{
	my ($line1,@ali1,@ali2,$i,$stpos1,$stpos2,$hifen_count1,$hifen_count2,$hitcount);
	my ( @iden_pos_query, @iden_pos_hit,$query_seq,$hit_seq,@query,@hit,@pos_query,@pos_hit);
	my (%AAscore,@matrix,@iden_ali_pos,@ali_pos);
	while(@iden_pos)
	{
		shift @identities;
		shift @bonus_score;
		shift @iden_pos;
	}
	while(@ali1)
	{
		shift @ali1;
		shift @ali2;
	}
	$query_seq=$hit_seq="";
	while(@iden_pos_query)
	{
		shift @iden_pos_query;
		shift @iden_pos_hit;
	}
	$hitcount=0;
	open SCORE1,$file3;
	while($line1=<SCORE1>)
	{
		#print $line1;
		if($line1=~ m/#\sScore:\s+(\d+\.\d+)/)
		{
			#$score[@score]=$1;
			if($hitcount >= 1)
			{
				chop $iden_pos_query[$hitcount-1];
				chop $iden_pos_hit[$hitcount-1];
				chop $iden_ali_pos[$hitcount-1];
			}
			$hitcount++;
		}
		if($line1 =~ m/^(#|\s)/)
		{
			next;
		}
		$line1 =~ m/^(.*)\s+(\d+)\s([\w-]+)\s+(\d+)/;
		$stpos1=$2;
		chomp $line1;
		@ali1=split("",$3);
		<SCORE1>;
		$line1=<SCORE1>;
		$line1 =~ m/^(.*)\s+(\d+)\s([\w-]+)\s+(\d+)/;
		$stpos2=$2;
		chomp $line1;
		@ali2=split("",$3);
		$hifen_count1=0;$hifen_count2=0;
		for($i=0;$i<scalar(@ali1);$i++)
		{
			if($ali1[$i] eq "-")
			{
				$hifen_count1++;
			}
			if($ali2[$i] eq "-")
			{
				$hifen_count2++;
			}
			if(($ali1[$i] eq "B")||($ali1[$i] eq "Z"))
			{
				if($ali1[$i] eq $ali2[$i])
				{
					$iden_pos_query[$hitcount-1]=$iden_pos_query[$hitcount-1].($stpos1+$i-$hifen_count1)." ";
					$iden_pos_hit[$hitcount-1]=$iden_pos_hit[$hitcount-1].($stpos2+$i-$hifen_count2)." ";
					$iden_ali_pos[$hitcount-1]=$iden_ali_pos[$hitcount-1].($stpos2+$i)." ";
				}
			}
		}
	}
	chop $iden_pos_query[$hitcount-1];
	chop $iden_pos_hit[$hitcount-1];
	chop $iden_ali_pos[$hitcount-1];
	close SCORE1;
	open SCORE2, $file1;
	while($line1=<SCORE2>)
	{
		if($line1 =~ m/^>/)
		{
			last;
		}
	}
	while($line1=<SCORE2>)
	{
		if($line1 =~ m/^>/)
		{
			last;
		}
		chomp $line1;
		$query_seq=$query_seq.$line1;
	}
	close SCORE2;
	$query_seq =~ s/\s+//g;
	@query=split("",$query_seq);
	open SCORE3, $file2;
	while($line1=<SCORE3>)
	{
		if($line1 =~ m/^>/)
		{
			$hitcount=1;
			last;
		}
	}
	while($line1=<SCORE3>)
	{
		if($hit_seq && ($line1 =~ m/^>/))
		{
			$hit_seq =~ s/\s+//g;
			@hit=split("",$hit_seq);
			@pos_query=split(" ",$iden_pos_query[$hitcount-1]);
			@pos_hit=split(" ",$iden_pos_hit[$hitcount-1]);
			@ali_pos=split(" ",$iden_ali_pos[$hitcount-1]);
			$identities[$hitcount-1]="";
			$iden_pos[$hitcount-1]="";
			for($i=0;$i<scalar(@pos_query);$i++)
			{
				if($query[$pos_query[$i]-1] eq $hit[$pos_hit[$i]-1])
				{
					$identities[$hitcount-1]=$identities[$hitcount-1]."$query[$pos_query[$i]-1]";
					$iden_pos[$hitcount-1]=$iden_pos[$hitcount-1]."$ali_pos[$i] ";
				}
			}
			$hitcount++;
			$hit_seq="";
			next;
		}
		chomp $line1;
		$hit_seq=$hit_seq.$line1;
	}
	$hit_seq =~ s/\s+//g;
	@hit=split("",$hit_seq);
	@pos_query=split(" ",$iden_pos_query[$hitcount-1]);
	@pos_hit=split(" ",$iden_pos_hit[$hitcount-1]);
	@ali_pos=split(" ",$iden_ali_pos[$hitcount-1]);
	$identities[$hitcount-1]="";
	$iden_pos[$hitcount-1]="";
	for($i=0;$i<scalar(@pos_query);$i++)
	{
		if($query[$pos_query[$i]-1] eq $hit[$pos_hit[$i]-1])
		{
			$identities[$hitcount-1]=$identities[$hitcount-1]."$query[$pos_query[$i]-1]";
			$iden_pos[$hitcount-1]=$iden_pos[$hitcount-1]."$ali_pos[$i] ";
		}
	}
	close SCORE3;
	$i=0;
	foreach $hit_seq (@iden_pos) {
	}
	open SCORE4,$matrix_selected;
	while($line1=<SCORE4>)
	{
		if($line1 =~ m/^(#|\s)/)
		{
			next;
		}
		$i++;
		if($i > 20)
		{
			last;
		}
		chomp $line1;
		@matrix=split(" +",$line1);
		$AAscore{$matrix[0]}=$matrix[$i];
	}
	close SCORE4;
	$hitcount=0;
	foreach $hit_seq (@identities) {
		$hitcount++;
		@hit=split("",$hit_seq);
		for($i=0;$i<scalar(@hit);$i++)
		{
			$bonus_score[$hitcount-1]=$bonus_score[$hitcount-1]+$AAscore{$hit[$i]};
		}
	}
}
#
# The function displays the options to 
# save upon calling the save alignment
#
sub save_op
{
		my ($D,$choice);
  $D = $mw->Dialog(
                 -title=>"SnS-Align",
                 -text  => "Save as ..",
                 -default_button => 'Text',
                 -buttons        => ['Text','Post Script','Cancel']
                       );
  $choice=$D->Show;
  if($choice eq "Text")
	{
	  save_text();
	}
 elsif($choice eq "Post Script")
	{
		save_ps();
	}
 elsif($choice eq "Cancel")
	{
		destroy $D;
	}
}
#
# The routine saves the canvas in the text version
# in the given output file
#
sub save_text
{
	my ($line,$align,@temp,@temp2,$tagline,$ids);my ($acount,$flag,$tcount);
	my (@SS_consAA,@SS_consAA_pos);
	$acount=$flag=$tcount=0;$tagline="";$ids="";
	my @types = (["Text Files", '.txt'],
               ["All Files", "*"] );
  my $file = $mw->getSaveFile(-filetypes => \@types,
				  -initialfile => 'textfile',
				  -defaultextension => '.txt');
  if(!$file)
	{
	  return;
	}
  open SAVEOUT,">$file";
  print SAVEOUT "SnS-Align Version 1.0\n# - implies alpha-Helix , \$ - implies beta-Sheet\n\n";
	open IN, $file3;
	while($line=<IN>)
	{
		chomp $line;
		if(!$line)
		{
			next;
		}
		if($line=~m/^(\s{5,}(\.|\:|\|)+)/)
		{
			next;
		}
		if($line=~m/^(\#)/)
		{
			if($line=~m/^(\#\sScore\:\s)(\d+)/)
			{
				$flag=1;
				$tagline=$tagline.", Score=".($2+$bonus_score[$acount]).$ids;
				@SS_consAA=split("",$identities[$acount]);
				chop $iden_pos[$acount];
				@SS_consAA_pos=split(" ",$iden_pos[$acount]);
				$ids="";
			}
			if($line=~m/^(\#\sIdentity\:\s+)\d+\/\d+\s+\(\s*(\d+\.\d)\%\)/)
			{
				$ids=$ids." (Identity=".$2."%";
			}
			if($line=~m/^(\#\sSimilarity\:\s+)\d+\/\d+\s+\(\s*(\d+\.\d)\%\)/)
			{
				$ids=$ids.", Similarity=".$2."%)";
			}
			if($line=~m/^(\#\s1:\s(.*))/)
			{
				$tagline=$2;
			}
			if($line=~m/^(\#\s2:\s(.*))/)
			{
				$tagline=$tagline." with ".$2;
			}
			next;
		}
		if($flag==1)
		{
			$flag=0;
			$acount++;
			$align="\nAlignment_".$acount.":\t".$tagline;
			$tagline="";
			print SAVEOUT $align."\n";
		}
		if($line=~m/^(.*)\s+(\d+)\s+((\w|\-)+)\s+(\d+)/)
		{
			$tcount++;
			$line=$1;
			while($line =~ m/(\s|\t)$/)
			{
				chop $line;
			}
			$align=$3;
			if(length($line) <= 7)
			{
				$line=$line."\t";
			}
			$line="\n$line"."\t(".$2."-".$5.")\t";
			if(length($2)+length($5)<=4)
			{
				$line=$line."\t";
			}
			print SAVEOUT $line;
			@temp2=@temp;
			@temp=split("",$align);
			foreach $line (@temp) {
			if($line eq "B")
				{
				print SAVEOUT "#";
				next;
				}
			if($line eq "Z")
				{
				print SAVEOUT "\$";
				next;
				}
			print SAVEOUT $line;
			}
			if($tcount==2)
			{
				$tcount=0;$line="";
				for($align=0;$align<@temp;$align++)
				{
					if($temp[$align] eq $temp2[$align])
					{
						if(($temp[$align] eq "B")|($temp[$align] eq "Z"))
						{
							if(($SS_consAA_pos[0]-$2)==$align)
							{
								$line=$line.$SS_consAA[0];
								shift @SS_consAA;shift @SS_consAA_pos;
							}
							else
							{
								$line=$line."*";
							}
						}
						else
						{
							$line=$line."+";
						}
					}
					else
					{
						$line=$line." ";
					}
				}
				$line=(" "x32).$line;
				print SAVEOUT "\n$line\n";
			}
		}
	}
	close IN;
	close SAVEOUT;
}
#
# The routine saves the canvas into a postscript file
# by using the Tk function postscript
#
sub save_ps {
  my @types = (["Post Script Files", '.ps'],
               ["All Files", "*"] );
  my $file = $mw->getSaveFile(-filetypes => \@types,
				  -initialfile => 'imagefile',
				  -defaultextension => '.ps');
  $textpad2->postscript(-x=>0,-y=>0,
						-width => $textpad2->width,
                        -height => $th,
						-file =>$file);
 
}
#
# The routine sorts the output of alignment obtained
# by smith-waterman algorithm
#
sub sort_file
{
	my ($ifile,$ofile,$sortline,@scores,$query,$hit,$identity,$similarity,$maxpos,$i,$j,$acount,$maxval);
	$ifile=$_[0];
	$ofile=$_[1];
	while(@hits)
	{
		pop @hits;
	}
	open SORTIN, $ifile;
	open SORTOUT,">$ofile";
	print SORTOUT "########################################\n";
	while($sortline=<SORTIN>)
	{
		if($sortline=~m/^(\#\s1:\s(.*))/)
		{
			$query=$2;
			next;
		}
		if($sortline=~m/^(\#\sMatrix\:\s+)/)
		{
			print SORTOUT $sortline;
			next;
		}
		if($sortline=~m/^(\#\sGap_penalty\:\s+)/)
		{
			print SORTOUT $sortline;
			next;
		}
		if($sortline=~m/^(\#\sExtend_penalty\:\s+)/)
		{
			print SORTOUT $sortline;
			last;
		}
	}
	print SORTOUT "########################################\n";
	$acount=0;
	while($sortline=<SORTIN>)
	{
		if($sortline =~ m/^(\#\sScore\:\s)(\d+.\d+)/)
		{
			if($bonus_score[$acount] eq "")
			{
				$bonus_score[$acount]=0;
			}
			$scores[@scores]=$2+$bonus_score[$acount];
			$acount++;
			next;
		}
	}
	for($i=0;$i<$acount;$i++)
	{
		$maxval=0;
		for($j=0;$j<$acount;$j++)
		{
			if($maxval < $scores[$j])
			{
				$maxval=$scores[$j];
				$maxpos=$j;
			}
		}
		$scores[@scores]=$scores[$maxpos];
		$identities[@identities]=$identities[$maxpos];
		$iden_pos[@iden_pos]=$iden_pos[$maxpos];
		$bonus_score[@bonus_score]=$bonus_score[$maxpos];
		$scores[$maxpos]=0;
	}
	for($i=0;$i<$acount;$i++)
	{
		shift @scores;
		shift @identities;
		shift @iden_pos;
		shift @bonus_score;
	}

	for ($i=0;$i<$acount;$i++)
	{
		$scores[$i]=$scores[$i]-$bonus_score[$i];
	}
#@scores=sort {$b <=> $a} @scores;
	close SORTIN;
	while(@scores)
	{
		open SORTIN, $ifile;
		while($sortline=<SORTIN>)
		{
			if($scores[0] !~ m/\./)
			{
				$scores[0]=$scores[0].".0";
			}
			if($sortline=~m/^(\#\s2:\s(.*))/)
			{
				$hit=$2;
				next;
			}
			elsif($sortline=~m/^(\#\sIdentity\:\s+)\d+\/\d+\s+\(\s*(\d+\.\d)\%\)/)
			{
				$identity=$sortline;
				next;
			}
			elsif($sortline=~m/^(\#\sSimilarity\:\s+)\d+\/\d+\s+\(\s*(\d+\.\d)\%\)/)
			{
				$similarity=$sortline;
				$hit=$hit."\t$2%";
				next;
			}
			elsif($sortline =~ m/^(\#\sScore\:\s)($scores[0])/)
			{
				$hits[@hits]=$hit."\t$2";
				print SORTOUT "#=======================================\n";
				print SORTOUT "# 1: $query\n";
				$hit=substr($hit,0,index($hit,"\t"));
				print SORTOUT "# 2: $hit\n";
				print SORTOUT $identity;
				print SORTOUT $similarity;
				print SORTOUT $sortline;
				<SORTIN>;<SORTIN>;
				$sortline=<SORTIN>;
				print SORTOUT $sortline;
				$sortline=<SORTIN>;
				while ($sortline ne "#=======================================\n")
				{
					print SORTOUT $sortline;
					$sortline=<SORTIN>;#print $sortline;<STDIN>;
					if($sortline eq "#---------------------------------------\n")
					{
						last;
					}
					if(!$sortline) { last; }
					
				}
				shift @scores;
				if(!@scores)
				{
					last;
				}
				if($sortline eq "#---------------------------------------\n")
				{
					last;
				}
				if(!$sortline) { last; }
			}
		}
		close SORTIN;
	}
	print SORTOUT "#---------------------------------------\n";
	close SORTOUT;
}
#
# The routine visualises the summary of SnS-Alignment
# in tabular format
#
sub view_summary
{
	my ($mw2,$hitvalue,$hitcount,@temp);my ($x,$y,$textpad3,$savetable);
	$hitcount=0;$x=25;$y=10;
	$mw2 = MainWindow->new(-title=>"SnS-Align - Summary of Alignments");
	$canvas1 = $mw2->Scrolled('Canvas',
                       -scrollbars => 'd',
                       );
	$textpad3 = $canvas1->Scrolled(
				'Canvas',
				-scrollbars => 'e',
				-width => 400,
				-background => 'white'
				);
	$textpad3->createText($x, $y, -text=>"S.No", -fill => 'red',-anchor => 'w', -font=>'LucidaConsole 10');
	$x=$x+40;
	 $textpad3->createText($x, $y, -text=>"Name (short description)", -fill => 'red',-anchor => 'w', -font=>'LucidaConsole 10');

	 $x=$x+200;
	 $textpad3->createText($x, $y, -text=>"Similarity", -fill => 'red',-anchor => 'w', -font=>'LucidaConsole 10');

	 $x=$x+70;
	 $textpad3->createText($x, $y, -text=>"Score", -fill => 'red',-anchor => 'w', -font=>'LucidaConsole 10');
	 $y=$y+20;
	foreach $hitvalue (@hits)
	{
	 $x=25;
	 $textpad3->createLine(25, $y-7, 380, $y-7,-fill=>'grey',-width=>1);
	 @temp=split("\t",$hitvalue);$hitcount++;
	 $textpad3->createText($x, $y, -text=>$hitcount, -fill => 'blue',-anchor => 'w', -font=>'LucidaConsole 10');

	 $x=$x+40;
	 if(length($temp[0]) > 25)
		{
			$temp[0] = substr($temp[0],0,25);
		}
	 $textpad3->createText($x, $y, -text=>$temp[0], -fill => 'blue',-anchor => 'w', -font=>'LucidaConsole 10');

	 $x=$x+200;
	 $textpad3->createText($x, $y, -text=>$temp[1], -fill => 'blue',-anchor => 'w', -font=>'LucidaConsole 10');

	 $x=$x+70;
	 $temp[2]=$temp[2]+$bonus_score[$hitcount-1];
	 $textpad3->createText($x, $y, -text=>$temp[2], -fill => 'blue',-anchor => 'w', -font=>'LucidaConsole 10');
	 $y=$y+15;
	}
	$textpad3->createLine(25, $y-7, 380, $y-7,-fill=>'grey',-width=>1);
	$savetable=  $canvas1->Button(-text => 'Save Table',-width => 15, -command =>  \&save_summary);
	$textpad3->configure(-scrollregion => [0, 0,400,$y+20]);
	$textpad3->grid(-row=>1,-column=>1,-columnspan=>3);
	$savetable->grid(-row=>2,-column=>3);
	$canvas1->grid();
	$mw2->resizable(0,0);
}
#
# The routine saves the summary of alignment in a
# text-file given by the user
#
sub save_summary
{
	my ($hit,$hitcount,@temp);
	my @types = (["Text Files", '.txt'],
                    ["All Files", "*"] );
	my $file = $mw->getSaveFile(-filetypes => \@types,
				  -initialfile => 'summary_textfile',
				  -defaultextension => '.txt');
	if(!$file)
	{
	  return;
	}
  open SAVEOUT,">$file";
  $hitcount=0;
  print SAVEOUT "S.No\tName (Short Description)\tSimilarity\tScore\n";
  print SAVEOUT "-" x 65;print SAVEOUT "\n";
  foreach $hit (@hits) {
		$hitcount++;
		@temp=split("\t",$hit);
		if(length($temp[0]) > 35)
	    {
			$temp[0]=substr($temp[0],0,35);
		}
		print SAVEOUT $hitcount."\t";
		print SAVEOUT $temp[0]." "x(36-length($temp[0]));
		print SAVEOUT $temp[1]."\t".($temp[2]+$bonus_score[$hitcount-1])."\n";
		print SAVEOUT "-" x 65;print SAVEOUT "\n";
  }
  close SAVEOUT;
  return;
}
#
# The routine asks the program to exit
#
sub Exit
{
	exit 0;
}
#
# Create the initial canvas which takes
# input parameters
#
sub create_canvas1 {
	my (@matrices,$temp);
	$mw->destroy();
    $mw = MainWindow->new(-title=>"SnS-Align");
	$mw->resizable(0,0);
	$canvas1 = $mw->Scrolled('Canvas',
                       -scrollbars => 'd',
					   -width => 400,
					   -height => 700,
                       );
		$textpad1 = $canvas1->Scrolled(
				'ROText',
				-scrollbars => 'd',
				-width => 50,
				-height => 1,
				);
     $file1 = $canvas1->Button(-text => 'Query',-width => 10, -height=>1,-font =>"LucidaConsole 8 bold",-command =>  \&load_file1);
		 $textpad2 = $canvas1->Scrolled(
				'ROText',
				-scrollbars => 'd',
				-width => 50,
				-height => 1,
				);
	 $file2 = $canvas1->Button(-text => 'DB',-font =>"LucidaConsole 8 bold",-width => 10, -command =>  \&load_file2);
	 $submit=  $canvas1->Button(-text => 'SnS Align', -width=>20,-command =>  \&ss_align,-font =>"LucidaConsole 8 bold");

	$GP=10.0;$GE=0.5;
	$P_label= $canvas1->Label( -text => 'GAP Penalty',
	);
	$GP_label= $canvas1->Label( -text => 'Opening',
	);
	$GP_value= $canvas1->Entry(-width => 10,-textvariable => \$GP);
	
	$GE_label= $canvas1->Label( -text => 'Extension',
	);
	$GE_value= $canvas1->Entry(-width => 10,-textvariable => \$GE);

	$s_list=$canvas1->BrowseEntry(
		-label => "Sequence",
		-variable => \$seq_selected,
			);
	$s_list->insert('end', "Protein");
	$s_list->insert('end', "DNA");

	$m_list= $canvas1->BrowseEntry(
		-label => "Scoring Matrix",
		-variable => \$matrix_selected,
			);
	@matrices=glob($path."data/*.ss");
	foreach (@matrices) {
		$temp=substr($_,rindex($_,"/")+1,rindex($_,".")-rindex($_,"/")-1);
		$m_list->insert('end', $temp);
	}
	$matrix_selected = "BLOSUM62";
	$seq_selected="Protein";
	$null_label1= $canvas1->Label();
	$null_label2= $canvas1->Label();
	$null_label3= $canvas1->Label();
	$file1 -> grid(-row=>2,-column=>1,-columnspan=>2);
	$file2 -> grid(-row=>4,-column=>1,-columnspan=>2);
	$textpad1 -> grid(-row=>2,-column=>3,-columnspan=>4);
	$textpad2 -> grid(-row=>4,-column=>3,-columnspan=>4);
	$s_list->grid(-row=>6,-column=>1,-columnspan=>4);
	$m_list->grid(-row=>6,-column=>5,-columnspan=>2);
	$null_label1->grid(-row=>5,-column=>1);
	$null_label2->grid(-row=>7,-column=>1);
	$null_label3->grid(-row=>9,-column=>1);
	$P_label->grid(-row=>8,-column=>1);
   	$GP_label->grid(-row=>8,-column=>3,-sticky=>'e');
	$GP_value->grid(-row=>8,-column=>4,-sticky=>'w');
	$GE_label->grid(-row=>8,-column=>5,-sticky=>'e');
	$GE_value->grid(-row=>8,-column=>6,-sticky=>'w');
	$submit -> grid(-row=>10,-column=>4,-columnspan=>2);
	$canvas1->grid();
	$geox=int(($mw->screenwidth-400)/2);
	$geoy=int(($mw->screenheight-$mw->reqheight)/2);
	$mw->geometry("+$geox+$geoy");
	$file1=$file2="";
}
#
# The routine creates the ouput canvas after parsing
# the temporary data file
#
sub recreate_canvas1
{
	my ($line,$align,@temp,@temp2,$tagline,$ids);my ($x,$y,$acount,$flag,$tcount);
	my (@SS_consAA,@SS_consAA_pos);
	$y=20; $acount=$flag=$tcount=0;$tagline="";$ids="";
	$canvas2 = $mw->Scrolled('Canvas',
                       -scrollbars => 'd',
					   -scrollregion => [0, 0, 600,800],
					   -width => 600,
					   -height => 800,
#					   -background => 'lightgreen',
					   -borderwidth => 20
                       );
	$textpad2 = $canvas2->Scrolled(
				'Canvas',
				-scrollregion => [0, 0, 700,800],
				-scrollbars => 'e',
				-background => 'white',
				-width => 700,
				-height =>400
				);
	open IN, $file3;
	$textpad2->createText(0, $y, -text=>"SnS-Align Version 1.0", -fill => 'red',-anchor => 'w', -font=>'CourierNew 10');
	$y=$y+25;
	$line=<IN>;
	if($line !~ m/^(\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#)$/)
	{
	$textpad2->createText(0, $y, -text=>"Error, occured in processing. Try again", -fill => 'red',-anchor => 'w', -font=>'CourierNew 10');

	}
	
	while($line=<IN>)
	{
		chomp $line;
		if(!$line)
		{
			next;
		}
		if($line=~m/^(\s{5,}(\.|\:|\|)+)/)
		{
			next;
		}
		if($line=~m/^(\#)/)
		{
			if($line=~m/^(\#\sScore\:\s)(\d+)/)
			{
				$flag=1;
				$tagline=$tagline.", Score=".($2+$bonus_score[$acount]).$ids;
				@SS_consAA=split("",$identities[$acount]);
				chop $iden_pos[$acount];
				@SS_consAA_pos=split(" ",$iden_pos[$acount]);
				$ids="";
			}
			if($line=~m/^(\#\sIdentity\:\s+)\d+\/\d+\s+\(\s*(\d+\.\d)\%\)/)
			{
				$ids=$ids." (Identity=".$2."%";
			}
			if($line=~m/^(\#\sSimilarity\:\s+)\d+\/\d+\s+\(\s*(\d+\.\d)\%\)/)
			{
				$ids=$ids.", Similarity=".$2."%)";
			}
			if($line=~m/^(\#\s1:\s(.*))/)
			{
				$tagline=$2;
			}
			if($line=~m/^(\#\s2:\s(.*))/)
			{
				$tagline=$tagline." with ".$2;
			}
			next;
		}
		if($flag==1)
		{
			$flag=0;
			if($acount > 0)
			{
				$y=$y+40;
			}
			$acount++;
			$align="Alignment_".$acount.":\t".$tagline;
			if(length($tagline) >=88)
			{
				$tagline=substr($align,0,index($align,","));
				$textpad2->createText(0, $y, -text=>$tagline, -fill => 'magenta',-anchor => 'w', -font=>'CourierNew 10');
				$tagline=substr($align,index($align,",")+2);
				$y=$y+20;
				$textpad2->createText(110, $y, -text=>$tagline, -fill => 'magenta',-anchor => 'w', -font=>'CourierNew 10');
			}
			else
			{
				$textpad2->createText(0, $y, -text=>$align, -fill => 'magenta',-anchor => 'w', -font=>'CourierNew 10');
			}
			$tagline="";
		}
		$y=$y+20;
		if($line=~m/^(.*)\s+(\d+)\s+((\w|\-)+)\s+(\d+)/)
		{
			$tcount++;
			$line=$1;
			while($line =~ m/(\s|\t)$/)
			{
				chop $line;
			}
			$align=$3;
			$line=$line."\t(".$2."-".$5.")";
			if(length($2)+length($5)<=6)
			{
				$line=$line."\t";
			}
			$textpad2->createText(0, $y, -text=>$line, -fill => 'blue',-anchor => 'w', -font=>'LucidaConsole 10',-width=>199);
			@temp2=@temp;
			@temp=split("",$align);
			$x=200;
			foreach $line (@temp) {
			if($line eq "B")
				{
				$textpad2->createLine($x+2, $y-2, $x+5, $y+2,-fill=>'purple',-width=>3);
				$textpad2->createLine($x+2, $y+2, $x+5, $y-2,-fill=>'purple',-width=>3);
				$textpad2->createArc($x-2,$y-4, $x+2, $y,-start=>0,-extent=>90,-style=>"arc",-outline => 'purple',-width=>3);
				$textpad2->createArc($x-2,$y, $x+2, $y+4,-start=>0,-extent=>-90,-style=>"arc",-outline => 'purple',-width=>3);
				$textpad2->createArc($x+5,$y-4,$x+9, $y,-start=>180,-extent=>-90,-style=>"arc",-outline => 'purple',-width=>3);
				$textpad2->createArc($x+5,$y, $x+9, $y+4,-start=>180,-extent=>90,-style=>"arc",-outline => 'purple',-width=>3);
				$textpad2->createLine($x, $y+2, $x, $y+2,-fill=>'purple',-width=>3);
				$textpad2->createLine($x-2, $y-4, $x+1, $y-4,-fill=>'purple',-width=>3);
				$textpad2->createLine($x-2, $y+4, $x+1, $y+4,-fill=>'purple',-width=>3);
				$x=$x+9;
				next;
				}
			if($line eq "Z")
				{
				$textpad2->createLine($x, $y-2, $x+8, $y-2,-fill=>'lightblue',-width=>3);
				$textpad2->createLine($x, $y+2, $x+8, $y+2,-fill=>'lightblue',-width=>3);
				$x=$x+9;
				next;
				}
			$textpad2->createText($x, $y, -text=>$line, -fill => 'blue',-anchor => 'w', -font=>'LucidaConsole 8 bold');
			$x=$x+9;
			}
			$x=200;
			if($tcount==2)
			{
				$y=$y+20;
				$tcount=0;$line="";
				for($align=0;$align<@temp;$align++)
				{
					if($temp[$align] eq $temp2[$align])
					{
						if(($temp[$align] eq "B")|($temp[$align] eq "Z"))
						{
							if(($SS_consAA_pos[0]-$2)==$align)
							{
								$line=$line.$SS_consAA[0];
								$textpad2->createText($x, $y-4, -text=>$SS_consAA[0], -fill => 'red',-anchor => 'w', -font=>'LucidaConsole 8');
								shift @SS_consAA;shift @SS_consAA_pos;
							}
							else
							{
								$line=$line."*";
								$textpad2->createText($x, $y, -text=>"*", -fill => 'red',-anchor => 'w', -font=>'LucidaConsole 12');
							}
							$x=$x+9;
						}
						else
						{
							$line=$line."+";
							$textpad2->createText($x, $y-4, -text=>"+", -fill => 'red',-anchor => 'w', -font=>'LucidaConsole 10');
							$x=$x+9;
						}
					}
					else
					{
						$line=$line." ";
						$x=$x+9;
					}
				}
			}
		}
	}
	$textpad2->configure(-scrollregion => [0, 0, 700,$y+20]);
	$canvas2->configure(-scrollregion => [0, 0, 700,$y+20]);
	$th=$y+20;
	close IN;
	$alignagain=  $canvas2->Button(-text => 'New Alignment',-width => 15, -command =>  \&create_canvas1);
	$savealign=  $canvas2->Button(-text => 'Save Alignment',-width => 15, -command =>  \&save_op);
	$viewsummary=  $canvas2->Button(-text => 'View Summary',-width => 15, -command =>  \&view_summary);
	$exit=  $canvas2->Button(-text => 'Exit',-width => 15, -command =>  \&Exit);
	$textpad2-> grid(-row=>2,-column=>1,-columnspan=>4);
	$viewsummary-> grid(-row=>3,-column=>1);
	$savealign-> grid(-row=>3,-column=>2);
	$alignagain-> grid(-row=>3,-column=>3);
	$exit-> grid(-row=>3,-column=>4);
	$canvas1->destroy();
	$canvas2->grid();
	$geox=int(($mw->screenwidth-720)/2);
	$geoy=int(($mw->screenheight-400)/2);
	$mw->geometry("+$geox+$geoy");
	$mw->update;

}
($tfile,$path) = fileparse($0, qr/\..*/); # Get the directory of the program
print $path."\n";
$mw = MainWindow->new;
create_canvas1(); 
MainLoop;
###################################################

